#include <DallasTemperature.h>

#include <OneWire.h>
#include <DallasTemperature.h>
// Data wire is plugged into port 2 on the Arduino
#define ONE_WIRE_BUS 2
// Setup a oneWire instance to communicate with any OneWire devices (not just Maxim/Dallas temperature ICs)

#define FAN_CONTROLLER 10


OneWire oneWire(ONE_WIRE_BUS);
// Pass our oneWire reference to Dallas Temperature.
DallasTemperature sensors(&oneWire);
void setup(void)
{
  pinMode(FAN_CONTROLLER, OUTPUT);
  
  // start serial port
  Serial.begin(9600);
  Serial.println("Dallas Temperature IC Control Library Demo");
  // Start up the library
  sensors.begin();
}

void loop(void)
{
  // call sensors.requestTemperatures() to issue a global temperature
  // request to all devices on the bus
 // Serial.print("Requesting temperatures...");
  sensors.requestTemperatures(); // Send the command to get temperatures
 // Serial.println("DONE");

  Serial.print("Temperature for the device 1 (index 0) is: ");
  Serial.print(sensors.getTempCByIndex(0));
  Serial.print(" C, ");
  Serial.print(sensors.getTempFByIndex(0));
  Serial.println(" F");

  /* Comment out Fahrenheit and uncomment Celcius  */
  if(sensors.getTempFByIndex(0) >= 77)
  {
    turnOnFan();
  }
  else
  {
    turnOffFan();
  }
  
  /*if(sensors.getTempCByIndex(0) >= 25)
  {
    turnOnFan();
  }else
  {
    turnOffFan();
  }*/
}

void turnOnFan()
{
  digitalWrite(FAN_CONTROLLER, HIGH);
}

void turnOffFan()
{
  digitalWrite(FAN_CONTROLLER, LOW);
}

