#include <SoftwareSerial.h>

SoftwareSerial Serial7SegmentMS(7, 8); //RX pin, TX pin
SoftwareSerial Serial7SegmentDH(9, 10); //RX pin, TX pin

const int pauseBtn = 11;  // pause button

int pauseBtnState;
int pauseBtnState2; //for debounce purposes
boolean isPaused;

int cycles = 0;

//From https://github.com/sparkfun/Serial7SegmentDisplay/wiki/Special-Commands#wiki-decimal
#define APOSTROPHE  5
#define COLON       4
#define DECIMAL4    3
#define DECIMAL3    2
#define DECIMAL2    1
#define DECIMAL1    0

long millisTimer;
byte seconds = 0;
byte minutes = 0;
byte hours = 0;
byte days = 0;

char tempStringMS[100]; //Used for sprintf
char tempStringDH[100]; //Used for sprintf

void setup() {

  Serial.begin(9600);
  Serial.println("Testing:");

  pinMode(pauseBtn, INPUT);

  isPaused = false;

  Serial7SegmentMS.begin(9600); //Talk to the Serial7Segment at 9600 bps
  Serial7SegmentMS.write('v'); //Reset the display - this forces the cursor to return to the beginning of the display
  
  Serial7SegmentDH.begin(9600);
  Serial7SegmentDH.write('v');

  millisTimer = millis();

  //For testing, we initialize the variables to the current time
  seconds = 00;
  minutes = 00;
  hours = 00;
  days = 00;
  
  
  Serial7SegmentMS.write(0x77);  // Decimal, colon, apostrophe control command
  Serial7SegmentMS.write(1<<COLON); // Turns on colon
  
  Serial7SegmentDH.write(0x77);
  Serial7SegmentDH.write(1<<COLON);
}

void loop() 
{
  pauseBtnState = digitalRead(pauseBtn);
  
  if(pauseBtnState == LOW)
  {
    Serial.println("LOW");
    delay(50);
    pauseBtnState2 = digitalRead(pauseBtn); //used for debounce purposes
    
    //if btn pressed and already paused, unpause it
    if(isPaused && (pauseBtnState == LOW) && (pauseBtnState2 == LOW))
    {
      //wait for the button to stop being pressed
      while(digitalRead(pauseBtn) == LOW)
        delay(50);
      
      isPaused = false;
      Serial.println("isPaused = false");
    }else if(!isPaused && (pauseBtnState == LOW) && (pauseBtnState2 == LOW)) //if not paused and button pressed, pause it
    {
      //wait for the button to stop being pressed
      while(digitalRead(pauseBtn) == LOW)
        delay(50);     
      
      isPaused = true;
      Serial.println("isPaused = true");
    }else //btn not pressed
    {
      isPaused = false;
      Serial.println("isPaused = false, neither LOW");
    }  
  }
    
  if(!isPaused)
  {
    Serial.println("running timer code");
    
      //Every second update the various variables and blink colon/apos/decimal
      if( (millis() - millisTimer) > 1000)
      {
        millisTimer += 1000; //Adjust the timer forward 1 second
    
        seconds++;
    
        if(seconds > 59)
        {
          seconds -= 60; //Reset seconds and increment minutes
          minutes++;
          
          if(minutes > 59)
          {
            minutes -= 60; //Reset minutes and increment hours
            hours++;
            
            if(hours > 23)
            {
              hours -= 24; //Reset hours
              days++;
              
              if(days>99)
                days -= 100;
            }
          }
        }
      }

      sprintf(tempStringMS, "%02d%02d", minutes, seconds);
      sprintf(tempStringDH, "%02d%02d", days, hours);
    
      Serial7SegmentMS.print(tempStringMS); //Send serial string out the soft serial port to the S7S
      Serial7SegmentDH.print(tempStringDH);
  }else
  {
     if( (millis() - millisTimer) > 1000) 
       millisTimer += 1000; //Adjust the timer forward 1 second to keep the same time while paused
  }

  delay(10);
}
