#include "Arduino.h"
#include "MorseCode.h"

MorseCode::MorseCode(int pin)
{
   _pin=pin; 
   pinMode(pin, OUTPUT);
}

void MorseCode::dot()
{
  delay (250);
  digitalWrite (_pin, HIGH);
  delay (250);
  turnoff();
}
void MorseCode::dash()
{
  delay (500);
  digitalWrite (_pin, HIGH);
  delay (500);
  turnoff();
}
void  MorseCode::New()
{
  turnoff();
  delay (1000);
}

void MorseCode::space()
{
  turnoff();
  delay (1000);
}


void MorseCode::turnoff()
{
 digitalWrite(_pin, LOW); 
}

void MorseCode::message(String msg)
{
	for(int i=0; i< msg.length(); i++)
	{
		switch(msg[i])
	 	{
		  case 'A':
		  case 'a':
		  	A();
			break;
		  case 'B':
		  case 'b':
		  	B();
			break;
 		  case 'C':
		  case 'c':
		  	C();
			break;
 		  case 'D':
		  case 'd':
		  	D();
			break;
		  case 'E':
		  case 'e':
		  	E();
			break;
 		  case 'F':
		  case 'f':
		  	F1();
			break;
 		  case 'G':
		  case 'g':
		  	G();
			break;
		  case 'H':
		  case 'h':
		  	H();
			break;
 		  case 'I':
		  case 'i':
		  	I();
			break;
 		  case 'J':
		  case 'j':
		  	J();
			break;
 		  case 'K':
		  case 'k':
		  	K();
			break;
 		  case 'L':
		  case 'l':
		  	L();
			break;
 		  case 'M':
		  case 'm':
		  	M();
			break;
 		  case 'N':
		  case 'n':
		  	N();
			break;
 		  case 'O':
		  case 'o':
		  	O();
			break;
 		  case 'P':
		  case 'p':
		  	P();
			break;
		  case 'Q':
		  case 'q':
		  	Q();
			break;
 		  case 'R':
		  case 'r':
		  	R();
			break;
 		  case 'S':
		  case 's':
		  	S();
			break;
 		  case 'T':
		  case 't':
		  	T();
			break;
 		  case 'U':
		  case 'u':
		  	U();
			break;
 		  case 'V':
		  case 'v':
			V();
			break;
 		  case 'W':
		  case 'w':
			W();
			break;
 		  case 'X':
		  case 'x':
		  	X();
			break;
 		  case 'Y':
		  case 'y':
		  	Y();
			break;
		  case 'Z':
		  case 'z':
		  	Z();
			break;
		}

		space();
	}

}

void MorseCode::A()
{
  dot();
  dash(); 
}

void MorseCode::B()
{
  dash();
  dot();
  dot();
  dot();
}

void MorseCode::C()
{
  dash();
  dot();
  dash();
  dot();
}

void MorseCode::D()
{
  dash();
  dot();
  dot();
}

void MorseCode::E()
{
  dot();
}

void MorseCode::F1()
{
  dot();
  dot();
  dash();
  dot();
}

void MorseCode::G()
{
  dash();
  dash();
  dot();
}

void MorseCode::H()
{
  dot();
  dot();
  dot();
  dot();
}

void MorseCode::I()
{
  dot();
  dot();
}

void MorseCode::J()
{
  dot();
  dash();
  dash();
  dash();
}

void MorseCode::K()
{
  dash();
  dot();
  dash();
}

void MorseCode::L()
{
  dot();
  dash();
  dot();
  dot();
}

void MorseCode::M()
{
  dash();
  dash();
}

void MorseCode::N()
{
  dash();
  dot();
}

void MorseCode::O()
{
  dash();
  dash();
  dash();
}

void MorseCode::P()
{
  dot();
  dash();
  dash();
  dot();
}

void MorseCode::Q()
{
  dash();
  dash();
  dot();
  dash();
}

void MorseCode::R()
{
  dot();
  dash();
  dot();
}

void MorseCode::S()
{
  dot();
  dot();
  dot();
}

void MorseCode::T()
{
  dash();
}

void MorseCode::U()
{
  dot();
  dot();
  dash();
}

void MorseCode::V()
{
  dot();
  dot();
  dot();
  dash();
}

void MorseCode::W()
{
  dot();
  dash();
  dash();
}

void MorseCode::X()
{
  dash();
  dot();
  dot();
  dash();
}

void MorseCode::Y()
{
  dash();
  dot();
  dash();
  dash();
}

void MorseCode::Z()
{
  dash();
  dash();
  dot();
  dot();
}